define('jqm.config', [ 'jquery' ],
    function ($) {
        $(window.document).on('mobileinit', function () {
            var _configureRouting = function _configureRouting() {
                    // disable jquery mobile routing to avoid conflict with backbone routing
                    $.mobile.autoInitializePage = false;
                    $.mobile.ajaxEnabled = false;
                    $.mobile.linkBindingEnabled = false;
                    $.mobile.hashListeningEnabled = false;
                    $.mobile.pushStateEnabled = false;
                    $.mobile.changePage.defaults.changeHash = false;
                    $.mobile.popup.prototype.options.history = false;
                },

                _configureThemes = function _configureThemes() {
                    // Page
                    $.mobile.page.prototype.options.theme = 'b';

                    // Toolbar/Footer
                    $.mobile.toolbar.prototype.options.trackPersistentToolbars = false;

                    // Panel
                    $.mobile.panel.prototype.options.theme = 'b';
                    $.mobile.panel.prototype.options.display = 'overlay';

                    // Dialog
                    // $.mobile.dialog.prototype.options.overlayTheme = "a";

                    // Popup
                    $.mobile.popup.prototype.options.theme = 'a';
                    $.mobile.popup.prototype.options.tolerance = '30,10';

                    // Button
                    $.mobile.button.prototype.options.theme = 'b';

                    // Checkboxradio
                    $.mobile.checkboxradio.prototype.options.theme = 'b';

                    // Collapsible
                    $.mobile.collapsible.prototype.options.expandCueText = ' select to expand content';
                    $.mobile.collapsible.prototype.options.collapseCueText = ' select to collapse content';
                    $.mobile.collapsible.prototype.options.theme = 'b';
                    $.mobile.collapsible.prototype.options.contentTheme = 'b';
                    $.mobile.collapsible.prototype.options.iconpos = 'left';
                    $.mobile.collapsible.prototype.options.collapsedIcon = 'carat-r';
                    $.mobile.collapsible.prototype.options.expandedIcon = 'carat-d';

                    // Listview
                    $.mobile.listview.prototype.options.theme = 'b';
                    $.mobile.listview.prototype.options.icon = false;

                    // Selectmenu
                    $.mobile.selectmenu.prototype.options.theme = 'b';
                    $.mobile.selectmenu.prototype.options.overlayTheme = null;

                    // Slider
                    $.mobile.slider.prototype.options.trackCorners = true;
                    $.mobile.slider.prototype.options.sliderCorners = true;
                    $.mobile.slider.prototype.options.handleCorners = true; // always true for track type
                    $.mobile.slider.prototype.options.handleShadow = false;

                    // Textinput
                    $.mobile.textinput.prototype.options.theme = 'a';
                    $.mobile.textinput.prototype.options.clearBtnShadow = false;
                },

                _customizePanel = function _customizePanel() {
                    $.mobile.panel.prototype.options.animate = false;
                    // adjusts height and position of _modal to not overlap page header
                    $.mobile.panel.prototype.options.classes.modalOpen = 'ui-panel-dismiss-open ui-panel-dismiss-position-top';
                    $.widget('mobile.panel', $.mobile.panel, {
                        // modifies calculation for _modal height to exclude page header
                        // and uses window.height instead of document.height
                        open: function (immediate) {
                            if (!this._open) {
                                var self = this,
                                    o = self.options,

                                    _openPanel = function () {
                                        self._off(self.document, 'panelclose');
                                        self._page().jqmData('panel', 'open');

                                        if ($.support.cssTransform3d && Boolean(o.animate) && o.display !== 'overlay') {
                                            self._wrapper.addClass(o.classes.animate);
                                            self._fixedToolbars().addClass(o.classes.animate);
                                        }

                                        if (!immediate && $.support.cssTransform3d && Boolean(o.animate)) {
                                            (self._wrapper || self.element)
                                                .animationComplete(complete, 'transition');
                                        }
                                        else {
                                            setTimeout(complete, 0);
                                        }

                                        if (o.theme && o.display !== 'overlay') {
                                            self._page().parent()
                                                .addClass(o.classes.pageContainer + '-themed ' + o.classes.pageContainer + '-' + o.theme);
                                        }

                                        self.element
                                            .removeClass(o.classes.panelClosed)
                                            .addClass(o.classes.panelOpen);

                                        self._positionPanel(true);

                                        self._pageContentOpenClasses = self._getPosDisplayClasses(o.classes.pageContentPrefix);

                                        if (o.display !== 'overlay') {
                                            self._page().parent()
                                                .addClass(o.classes.pageContainer);
                                            self._wrapper.addClass(self._pageContentOpenClasses);
                                            self._fixedToolbars().addClass(self._pageContentOpenClasses);
                                        }

                                        // modifies calculation for _modal height to exclude page header
                                        // and uses window.height instead of document.height
                                        self._modalOpenClasses = self._getPosDisplayClasses(o.classes.modal) + ' ' + o.classes.modalOpen;
                                        // TODO: correct main.html for jQM template
                                        var parentPageHeaderHeight = self._parentPage ? self._parentPage.find(":jqmData(role='header')").first()
                                            .outerHeight() : 0;
                                        // var parentPageHeaderHeight = self._parentPage ? self._parentPage.children( ":jqmData(role='header')" ).outerHeight() : 0;
                                        if (self._modal) {
                                            self._modal
                                                .addClass(self._modalOpenClasses)
                                                .height(Math.max(self._modal.height(), self.window.height()) - parentPageHeaderHeight);
                                        }
                                    },
                                    complete = function () {

                                        // Bail if the panel was closed before the opening animation has completed
                                        if (!self._open) {
                                            return;
                                        }

                                        if (o.display !== 'overlay') {
                                            self._wrapper.addClass(o.classes.pageContentPrefix + '-open');
                                            self._fixedToolbars().addClass(o.classes.pageContentPrefix + '-open');
                                        }

                                        self._bindFixListener();

                                        self._trigger('open');

                                        self._openedPage = self._page();
                                    };

                                self._trigger('beforeopen');

                                if (self._page().jqmData('panel') === 'open') {
                                    self._on(self.document, {'panelclose': _openPanel});
                                }
                                else {
                                    _openPanel();
                                }

                                self._open = true;
                            }
                        },
                    });
                };

            var _customisePopup = function () {
                $.widget('mobile.popup', $.mobile.popup, {
                    // checks for null first
                    _safelyBlur: function (currentElement) {
                        if (currentElement && currentElement !== this.window[0] &&
							currentElement.nodeName.toLowerCase() !== 'body') {
                            $(currentElement).blur();
                        }
                    },
                });
            };

            var _customizeCollapsible = function () {
                // NOTE: these are the functions for mobile.collapsible that we are customizing
                // currently copied as-is from jquery.mobile 1.4.5
                // NOTE: _enhance will be modified so that that the originalHeading is wrapped with an aria-hidden element,
                // and the originalHeading text is prepended to the ui-collapsible-heading status
                $.widget('mobile.collapsible', $.mobile.collapsible, {
                    _enhance: function (elem, ui) {
                        var iconclass;
                        var opts = this._renderedOptions;
                        var contentThemeClass = this._themeClassFromOption('ui-body-', opts.contentTheme);

                        elem.addClass('ui-collapsible ' +
							(opts.inset ? 'ui-collapsible-inset ' : '') +
							(opts.inset && opts.corners ? 'ui-corner-all ' : '') +
							(contentThemeClass ? 'ui-collapsible-themed-content ' : ''));
                        ui.originalHeading = elem.children(this.options.heading).first();
                        ui.content = elem
                            .wrapInner('<div ' +
								"class='ui-collapsible-content " +
								contentThemeClass + "'></div>")
                            .children('.ui-collapsible-content');
                        ui.heading = ui.originalHeading;

                        // Replace collapsibleHeading if it's a legend
                        if (ui.heading.is('legend')) {
                            ui.heading = $("<div role='heading'>" + ui.heading.html() + '</div>');
                            ui.placeholder = $('<div><!-- placeholder for legend --></div>').insertBefore(ui.originalHeading);
                            ui.originalHeading.remove();
                        }

                        iconclass = (opts.collapsed ? (opts.collapsedIcon ? 'ui-icon-' + opts.collapsedIcon : '') :
                            (opts.expandedIcon ? 'ui-icon-' + opts.expandedIcon : ''));

                        ui.status = $("<span class='ui-collapsible-heading-status'></span>");
                        ui.anchor = ui.heading
                            .detach()
                            // modify markup & attributes
                            .addClass('ui-collapsible-heading')
                            .append(ui.status)
                            .wrapInner("<a href='#' class='ui-collapsible-heading-toggle'></a>")
                            .find('a')
                            .first()
                            .addClass('ui-btn ' +
								(iconclass ? iconclass + ' ' : '') +
								(iconclass ? iconposClass(opts.iconpos) +
								' ' : '') +
								this._themeClassFromOption('ui-btn-', opts.theme) + ' ' +
								(opts.mini ? 'ui-mini ' : ''));

                        // drop heading in before content
                        ui.heading.insertBefore(ui.content);

                        this._handleExpandCollapse(this.options.collapsed);

                        return ui;
                    },
                    // NOTE: _handleExpandCollapse will be modified so that
                    // the originalHeading is prepended to the cueText in ui.status.text
                    _handleExpandCollapse: function (isCollapse) {
                        var opts = this._renderedOptions,
                            ui = this._ui;

                        ui.status.text(ui.heading.find('[aria-hidden="true"]').text() + (isCollapse ? opts.expandCueText : opts.collapseCueText));
                        ui.heading
                            .toggleClass('ui-collapsible-heading-collapsed', isCollapse)
                            .find('a')
                            .first()
                            .toggleClass('ui-icon-' + opts.expandedIcon, !isCollapse)

                        // logic or cause same icon for expanded/collapsed state would remove the ui-icon-class
                            .toggleClass('ui-icon-' + opts.collapsedIcon, (isCollapse || opts.expandedIcon === opts.collapsedIcon))
                            .removeClass($.mobile.activeBtnClass);

                        this.element.toggleClass('ui-collapsible-collapsed', isCollapse);
                        ui.content
                            .toggleClass('ui-collapsible-content-collapsed', isCollapse)
                            .attr('aria-hidden', isCollapse)
                            .trigger('updatelayout');
                        this.options.collapsed = isCollapse;
                        this._trigger(isCollapse ? 'collapse' : 'expand');
                    },
                });
            };

            _configureRouting();
            _configureThemes();
            _customizePanel();
            _customisePopup();
            _customizeCollapsible();
        });
    });
